
CREATE TABLE users (
 id INT AUTO_INCREMENT PRIMARY KEY,
 name VARCHAR(100),
 email VARCHAR(100) UNIQUE,
 password VARCHAR(255),
 role ENUM('user','admin') DEFAULT 'user',
 status ENUM('active','blocked') DEFAULT 'active',
 last_seen TIMESTAMP NULL,
 created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE profiles (
 id INT AUTO_INCREMENT PRIMARY KEY,
 user_id INT,
 gender VARCHAR(10),
 dob DATE,
 education VARCHAR(150),
 occupation VARCHAR(150),
 religion VARCHAR(50),
 address VARCHAR(150),
 marital_status VARCHAR(50),
 bio TEXT,
 views INT DEFAULT 0,
 FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

CREATE TABLE proposals (
 id INT AUTO_INCREMENT PRIMARY KEY,
 from_user INT,
 to_user INT,
 status ENUM('pending','accepted','rejected') DEFAULT 'pending',
 created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
